/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNamed;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNullable;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeUniquelyNamed;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueOptionalBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeItemStackLPElement;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeLPElementBase;

public class ValueObjectTypeBlock
extends ValueObjectTypeBase<ValueBlock>
implements IValueTypeNamed<ValueBlock>,
IValueTypeUniquelyNamed<ValueBlock>,
IValueTypeNullable<ValueBlock> {
    public ValueObjectTypeBlock() {
        super("block", ValueBlock.class);
    }

    public static MutableComponent getBlockkDisplayNameSafe(BlockState blockState) {
        return new TranslatableComponent(blockState.m_60734_().m_7705_());
    }

    @Override
    public ValueBlock getDefault() {
        return ValueBlock.of(Blocks.f_50016_.m_49966_());
    }

    @Override
    public MutableComponent toCompactString(ValueBlock value) {
        if (value.getRawValue().isPresent()) {
            BlockState blockState = (BlockState)value.getRawValue().get();
            ItemStack itemStack = BlockHelpers.getItemStackFromBlockState((BlockState)blockState);
            if (!itemStack.m_41619_()) {
                return ValueObjectTypeItemStack.getItemStackDisplayNameSafe(itemStack);
            }
            return ValueObjectTypeBlock.getBlockkDisplayNameSafe(blockState);
        }
        return new TextComponent("");
    }

    @Override
    public Tag serialize(ValueBlock value) {
        if (!value.getRawValue().isPresent()) {
            return new CompoundTag();
        }
        return BlockHelpers.serializeBlockState((BlockState)((BlockState)value.getRawValue().get()));
    }

    @Override
    public ValueBlock deserialize(Tag value) {
        if (value.m_7060_() == 0 || value.m_7060_() == 10 && ((CompoundTag)value).m_128456_()) {
            return ValueBlock.of(Blocks.f_50016_.m_49966_());
        }
        return ValueBlock.of(BlockHelpers.deserializeBlockState((CompoundTag)((CompoundTag)value)));
    }

    @Override
    public String getName(ValueBlock a) {
        return this.toCompactString(a).getString();
    }

    @Override
    public boolean isNull(ValueBlock a) {
        return !a.getRawValue().isPresent();
    }

    @Override
    public ValueTypeLPElementBase createLogicProgrammerElement() {
        return new ValueTypeItemStackLPElement<ValueBlock>(this, new ValueTypeItemStackLPElement.IItemStackToValue<ValueBlock>(){

            @Override
            public boolean isNullable() {
                return true;
            }

            @Override
            public Component validate(ItemStack itemStack) {
                if (!itemStack.m_41619_() && !(itemStack.m_41720_() instanceof BlockItem)) {
                    return new TranslatableComponent("valuetype.integrateddynamics.error.block.no_block");
                }
                return null;
            }

            @Override
            public ValueBlock getValue(ItemStack itemStack) {
                return ValueBlock.of(itemStack.m_41619_() ? Blocks.f_50016_.m_49966_() : BlockHelpers.getBlockStateFromItemStack((ItemStack)itemStack));
            }
        });
    }

    @Override
    public String getUniqueName(ValueBlock value) {
        if (value.getRawValue().isPresent()) {
            BlockState blockState = (BlockState)value.getRawValue().get();
            return blockState.m_60734_().getRegistryName().toString();
        }
        return "";
    }

    public static class ValueBlock
    extends ValueOptionalBase<BlockState> {
        private ValueBlock(BlockState blockState) {
            super(ValueTypes.OBJECT_BLOCK, blockState);
        }

        public static ValueBlock of(BlockState blockState) {
            return new ValueBlock(blockState);
        }

        @Override
        protected boolean isEqual(BlockState a, BlockState b) {
            return a.equals(b);
        }

        @Override
        public String toString() {
            return "ValueObjectTypeBlock.ValueBlock()";
        }
    }
}

